#define MAX_BUTTON 64

#define YELLOW					0xFFFF00AA
#define RED					0xAA3333AA

#define BUTTON_DATA_WORLD		(0)
#define BUTTON_DATA_INTERIOR		(1)
#define BUTTON_DATA_TYPE		(2)

#define BUTTON_TYPE_GEN			(0)
#define BUTTON_TYPE_TP			(1)
#define BUTTON_TYPE_NOTE		(2)

#define TogCon(%1,%2) TogglePlayerControllable(%2,false),SetTimerEx("UnFreezePlayer",%1,false,"d",%2)
#define strcpy(%0,%1) strcat((%0[0] = '\0', %0), %1)

/*
native CreateButton(Float:x, Float:y, Float:z, msg[], world=0, interior=0, type=0, label=0)
native LinkTP(buttonid1, buttonid2)
native UnLinkTP(buttonid1, buttonid2)
native IsValidButtonID(buttonid)
native IsButtonActive(buttonid)
native SetButtonMessage(buttonid, msg[])
native SetButtonUsable(buttonid, bool:toggle)
native SetButtonLabelColour(buttonid, colour)
*/


new
	ButtonData[MAX_BUTTON][3],
	ButtonArea[MAX_BUTTON],
	Text3D:ButtonLabel[MAX_BUTTON],
	ButtonString[MAX_BUTTON][128],
	bool:ButtonActive[MAX_BUTTON],
	bool:ButtonIdUsed[MAX_BUTTON],
	LinkedButton[MAX_BUTTON];

forward OnButtonPress(playerid, buttonid);
forward UnFreezePlayer(playerid);
public UnFreezePlayer(playerid)TogglePlayerControllable(playerid, true);
// Used so the player doesn't fall through custom maps


// Message Box Script
new
	PlayerText:MsgBox,
	bool:MsgShown[MAX_PLAYERS];
forward HideMsgBox(playerid);
ShowMsgBox(playerid, message[], time=0)
{
	PlayerTextDrawSetString(playerid, MsgBox, message);
	PlayerTextDrawShow(playerid, MsgBox);
	MsgShown[playerid]=true;
	if(time!=0)SetTimerEx("HideMsgBox", time, false, "d", playerid);
}
public HideMsgBox(playerid)
{
	PlayerTextDrawHide(playerid, MsgBox);
	MsgShown[playerid] = false;
}


stock CreateButton(Float:x, Float:y, Float:z, msg[], world=0, interior=0, type=0, label=0)
{
	new id;
	while(ButtonActive[id])id++;
	if(id>=MAX_BUTTON)return print("BUTTON ID LIMIT REACHED");

	ButtonArea[id]=CreateDynamicSphere(x, y, z, 1.0, world, interior);
	if(label)ButtonLabel[id]=CreateDynamic3DTextLabel(msg, YELLOW, x, y, z, 10.0, _, _, 1, world, interior, _, 10.0);
	LinkedButton[id]=-1;
	strcpy(ButtonString[id], msg);
	ButtonData[id][BUTTON_DATA_WORLD] = world;
	ButtonData[id][BUTTON_DATA_INTERIOR] = interior;
	ButtonData[id][BUTTON_DATA_TYPE] = type;

	ButtonActive[id]=true;
	ButtonIdUsed[id]=true;

	return id;
}

stock LinkTP(buttonid1, buttonid2)
{
	if(ButtonIdUsed[buttonid1] || ButtonIdUsed[buttonid2])return 0;
	LinkedButton[buttonid1]=bID2;
	LinkedButton[buttonid2]=bID1;
	return 1;
}
stock UnLinkTP(buttonid1, buttonid2)
{
	if(ButtonIdUsed[buttonid1] || ButtonIdUsed[buttonid2])return 0;
	LinkedButton[buttonid1]=-1;
	LinkedButton[buttonid2]=-1;
	return 1;
}

Internal_OnButtonPress(playerid, buttonid)
{
	if(!ButtonActive[buttonid])return 0;
	if(LinkedButton[buttonid] >= 0)
	{
		new
			id = LinkedButton[buttonid],
			Float:x,
			Float:y,
			Float:z;

		Streamer_GetFloatData(STREAMER_TYPE_AREA, ButtonArea[id], E_STREAMER_X, x);
		Streamer_GetFloatData(STREAMER_TYPE_AREA, ButtonArea[id], E_STREAMER_Y, y);
		Streamer_GetFloatData(STREAMER_TYPE_AREA, ButtonArea[id], E_STREAMER_Z, z);

        TogCon(1000, playerid);
		SetPlayerVirtualWorld(playerid, ButtonData[id]{BUTTON_DATA_WORLD});
		SetPlayerInterior(playerid, ButtonData[id]{BUTTON_DATA_INTERIOR});
		SetPlayerPos(playerid, x, y, z);
		Streamer_UpdateEx(playerid, x, y, z, ButtonData[id]{BUTTON_DATA_WORLD}, ButtonData[id]{BUTTON_DATA_INTERIOR});
	}
	else CallLocalFunction("OnButtonPress", "dd", playerid, buttonid);
	return 1;
}



// Extra functions for external use

stock IsValidButtonID(buttonid)
{
	if(ButtonIdUsed[buttonid])return 1;
	return 0;
}
stock IsButtonActive(buttonid)
{
	if(ButtonActive[buttonid])return 1;
	return 0;
}

stock SetButtonMessage(buttonid, msg[])
{
	if(!IsValidButtonID(buttonid))return 0;
	strcpy(ButtonString[buttonid], msg);
	for(new i;i<MAX_PLAYERS;i++)if(MsgShown[i])PlayerTextDrawSetString(i, MsgBox, msg);
	UpdateDynamic3DTextLabelText(ButtonLabel[buttonid], YELLOW, msg);
	return 1;
}
stock SetButtonUsable(buttonid, bool:toggle)
{
	if(!IsValidButtonID(buttonid))return 0;
	if(toggle)
	{
		UpdateDynamic3DTextLabelText(ButtonLabel[buttonid], YELLOW, ButtonString[buttonid]);
		ButtonActive[buttonid] = true;
	}
	else
	{
		UpdateDynamic3DTextLabelText(ButtonLabel[buttonid], RED, ButtonString[buttonid]);
		ButtonActive[buttonid] = false;
	}
	return 1;
}
stock SetButtonLabelColour(buttonid, colour)
{
	if(!IsValidButtonID(buttonid))return 0;
	UpdateDynamic3DTextLabelText(ButtonLabel[buttonid], colour, ButtonString[buttonid]);
	return 1;
}


//


public OnPlayerEnterDynamicArea(playerid, areaid)
{
    for(new x;x<MAX_BUTTON;x++)
	{
		if(areaid==ButtonArea[x])
		{
			ShowMsgBox(playerid, ButtonString[x]);
			break;
		}
	}
	CallLocalFunction("BTN_OnPlayerEnterDynamicArea", "dd", playerid, areaid);
}
#if defined _ALS_OnPlayerEnterDynamicArea
	#undef OnPlayerEnterDynamicArea
#else
	#define _ALS_OnPlayerEnterDynamicArea
#endif
#define OnPlayerEnterDynamicArea BTN_OnPlayerEnterDynamicArea
forward OnPlayerEnterDynamicArea(playerid, areaid);


//


public OnPlayerLeaveDynamicArea(playerid, areaid)
{
    for(new x;x<MAX_BUTTON;x++)
	{
		if(areaid==ButtonArea[x])
		{
			HideMsgBox(playerid);
			break;
		}
	}
	CallLocalFunction("BTN_OnPlayerLeaveDynamicArea", "dd", playerid, areaid);
}
#if defined _ALS_OnPlayerLeaveDynamicArea
	#undef OnPlayerLeaveDynamicArea
#else
	#define _ALS_OnPlayerLeaveDynamicArea
#endif
#define OnPlayerLeaveDynamicArea BTN_OnPlayerLeaveDynamicArea
forward OnPlayerLeaveDynamicArea(playerid, areaid);


//


public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
    if(newkeys==16)
	{
		for(new i;i<MAX_BUTTON;i++)
		{
			if(IsPlayerInDynamicArea(playerid, ButtonArea[i]))
			{
				Internal_OnButtonPress(playerid, i);
				break;
			}
		}
	}
	CallLocalFunction("BTN_OnPlayerKeyStateChange", "ddd", playerid, newkeys, oldkeys);
}
#if defined _ALS_OnPlayerKeyStateChange
	#undef OnPlayerKeyStateChange
#else
	#define _ALS_OnPlayerKeyStateChange
#endif
#define OnPlayerKeyStateChange BTN_OnPlayerKeyStateChange
forward OnPlayerKeyStateChange(playerid, newkeys, oldkeys);


public OnGameModeInit()
{
	for(new id;id<MAX_PLAYERS;id++)
	{
		MsgBox					=CreatePlayerTextDraw(id, 37.000000, 130.00000, "_");
		PlayerTextDrawUseBox	(id, MsgBox, 1);
		PlayerTextDrawBoxColor	(id, MsgBox, 0x00000033);
		PlayerTextDrawTextSize	(id, MsgBox, 300, 300);
		PlayerTextDrawFont		(id, MsgBox, 1);
		PlayerTextDrawLetterSize(id, MsgBox, 0.499999, 1.600000);
		PlayerTextDrawSetShadow	(id, MsgBox, 0);
	}
	CallLocalFunction("BTN_OnGameModeInit", "");
}
#if defined _ALS_OnGameModeInit
	#undef OnGameModeInit
#else
	#define _ALS_OnGameModeInit
#endif
#define OnGameModeInit BTN_OnGameModeInit
forward OnGameModeInit();